/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.cec;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.hsc.common.util.InfoPanel;
import com.ibm.hsc.websm.lpar.LPARActivateDialog;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOXContainerObj;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class HSCResRecoverBean
extends AuimlDataBeanAdapter
implements TaskActionListener {
    public static final String COMMON_BUNDLE_NAME = "HSCCommonBundle";
    public static final String DLPAR_BUNDL_NAME = "DLPARBundle";
    public static final String OK_BUTTON_NAME = "UnassignedBtn";
    public static final String NAME_PROP = "name";
    protected String mCecKey;
    protected MOClass mMOClass;
    protected UserTaskManager mUsrTaskMgr = null;
    protected String mUserDefinedName = null;
    protected String mPanelName = null;
    protected String mAuimlClassName = null;
    protected boolean mFromDLPARGui = false;
    protected boolean mNeedLoadData = false;
    protected ItemDescriptor[] mRecoverTableId;
    protected ColumnDescriptor[] mRecoverTableStructureCd;
    protected int[] mRecoverTableSelection;
    protected String[] mParColStr;
    protected ItemDescriptor[] mParColId;
    protected String mInfoArea;
    protected boolean mFromActivate = true;
    protected Vector mParNames = null;
    protected Vector mParIntNames = null;
    protected MOXContainerObj mLparContainer = null;
    protected Throwable mLoadException = null;
    protected String mActivateMsg = null;
    protected String mActProfile = null;

    public void setServerConn(MOXContainerObj mOXContainerObj) {
        this.mCecKey = mOXContainerObj.getKey();
        System.out.println("cecKey: " + this.mCecKey);
        this.mMOClass = mOXContainerObj.getMOClass();
        this.mUserDefinedName = (String)mOXContainerObj.getPropertyValue(NAME_PROP);
        if (IDebug.enabled) {
            System.out.println("mUserDefinedName: " + this.mUserDefinedName);
        }
    }

    public void setUsrTaskMgr(UserTaskManager userTaskManager) {
        this.mUsrTaskMgr = userTaskManager;
        this.setDynamicValues();
    }

    public Throwable getLoadException() {
        return this.mLoadException;
    }

    protected Hashtable loadDataFromServer(String string) throws Exception {
        Object[] objectArray = new Object[]{this.mCecKey};
        Object object = this.mMOClass.invokeStaticMethod(string, objectArray);
        return (Hashtable)object;
    }

    protected boolean saveDataToServer(String string, Object[] objectArray) throws Exception {
        try {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            objectArray2[0] = this.mCecKey;
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n + 1] = objectArray[n];
                ++n;
            }
            if (IDebug.enabled) {
                System.out.println("methodName: " + string);
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    System.out.println("args[" + n2 + "]: " + objectArray2[n2]);
                    ++n2;
                }
            }
            this.mMOClass.invokeStaticMethod(string, objectArray2);
            return true;
        }
        catch (Throwable throwable) {
            this.handleException(throwable, null);
            return false;
        }
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        block8: {
            try {
                String string = taskActionEvent.getElementName();
                System.out.println("In action performed: " + string);
                if (string.endsWith(OK_BUTTON_NAME)) {
                    System.out.println("OKButtonName: " + string);
                    this.mUsrTaskMgr.storeAllElements();
                    if (IDebug.enabled) {
                        System.out.println("bef saveChanges");
                    }
                    if (this.saveChanges()) {
                        if (!this.mFromActivate) {
                            this.showDLPARDialog();
                        } else {
                            LPARActivateDialog.showDialog(this.mLparContainer, null, this.mActProfile);
                        }
                        this.mUsrTaskMgr.dispose();
                    }
                    if (!IDebug.enabled) break block8;
                    System.out.println("aft saveChanges");
                    break block8;
                }
                System.out.println("elemName: " + string);
                if (!this.mFromActivate) {
                    this.showDLPARDialog();
                }
                this.mUsrTaskMgr.dispose();
            }
            catch (Throwable throwable) {
                this.handleException(throwable, null);
                this.mUsrTaskMgr.dispose();
            }
        }
    }

    protected abstract boolean saveChanges() throws Exception;

    protected abstract void showDLPARDialog();

    public void setActivateInfo(String string, String string2, MOXContainerObj mOXContainerObj) {
        this.mLparContainer = mOXContainerObj;
        this.mActivateMsg = string;
        this.mActProfile = string2;
    }

    public void handleException(Throwable throwable, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            String string2 = null;
            if (IDebug.enabled) {
                System.out.println("check remote source exception");
            }
            if (throwable instanceof HSCException) {
                if (IDebug.enabled) {
                    System.out.println("get HSCRMCException");
                }
                HSCException hSCException = (HSCException)throwable;
                string2 = string == null ? hSCException.getMessage() : string + "\n" + hSCException.getMessage();
            }
            if (string2 == null) {
                string2 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDL_NAME, "ERR_GUI_EXCEPTION", "HMCERRV3DLPAR015: Caught unexpected exception {0} \n", new String[]{throwable.toString()});
                string2 = string2 + byteArrayOutputStream.toString();
            }
            this.showInfo(string2, null, null);
            printStream.close();
            byteArrayOutputStream.close();
            throwable.printStackTrace(System.out);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.out);
        }
    }

    public void showInfo(String string, String string2, String string3) {
        InfoPanel infoPanel = new InfoPanel(string, string2, string3);
        infoPanel.show();
    }

    public void setDynamicValues() {
        String string = this.mUsrTaskMgr.getCaptionText(this.mPanelName);
        this.mUsrTaskMgr.setCaptionText(this.mPanelName, string + " " + this.mUserDefinedName);
    }

    public String getAuimlClassName() {
        return this.mAuimlClassName;
    }

    public String getPanelName() {
        return this.mPanelName;
    }

    public void setRecoverData(Hashtable hashtable, MOXContainerObj mOXContainerObj) {
        System.out.println("setRecoverInfo");
        this.mFromActivate = false;
        this.mLparContainer = mOXContainerObj;
        this.loadRecoverData(hashtable);
    }

    protected abstract void loadRecoverData(Hashtable var1);

    public ColumnDescriptor[] getRecoverTableRowStructure() {
        return this.mRecoverTableStructureCd;
    }

    public int getRecoverTableRowStatus() {
        return 3;
    }

    public int getRecoverTableRowCount() {
        return 0;
    }

    public ItemDescriptor[] getRecoverTableRowAt(int n) {
        return this.mRecoverTableId;
    }

    public void setRecoverTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mRecoverTableId = itemDescriptorArray;
    }

    public int[] getRecoverTableSelection() {
        return this.mRecoverTableSelection;
    }

    public void setRecoverTableSelection(int[] nArray) throws IllegalUserDataException {
        this.mRecoverTableSelection = nArray;
    }

    public void setParColList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        this.mParColId = itemDescriptorArray;
    }

    public ItemDescriptor[] getParColList() {
        return this.mParColId;
    }

    public String[] getParColSelection() {
        return this.mParColStr;
    }

    public void setParColSelection(String[] stringArray) throws IllegalUserDataException {
        this.mParColStr = stringArray;
    }

    public String getInfoArea() {
        return this.mInfoArea;
    }

    public void setInfoArea(String string) {
        this.mInfoArea = string;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.mRecoverTableId = new ItemDescriptor[0];
        this.mRecoverTableStructureCd = new ColumnDescriptor[0];
        this.mRecoverTableSelection = new int[0];
        this.mParColStr = new String[0];
        this.mParColId = new ItemDescriptor[0];
    }
}

